// $Id: CFontEnumerator.cpp,v 1.5 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CFontEnumerator.hpp"
using Exponent::GUI::Fonts::CFontEnumerator;

//  ===========================================================================
CFontEnumerator::CFontEnumerator() : m_fontArray(NULL)
{
	m_fontArray = new TCountedPointerArray<CFontReference>;
	this->findFonts();
}

//  ===========================================================================
CFontEnumerator::~CFontEnumerator()
{
	FREE_POINTER(m_fontArray);
}

//  ===========================================================================
bool CFontEnumerator::fontExists(const CString &fontName)
{
	CString theFont = fontName;
	for (long i = 0; i < m_fontArray->getArraySize(); i++)
	{
		CFontReference *reference = m_fontArray->elementAtIndex(i);
		if (reference && theFont == reference->getFacename())
		{
			return true;
		}
	}
	return false;
}

#ifdef WIN32
//  ===========================================================================
long CALLBACK CFontEnumerator::enumerateProcess(ENUMLOGFONTEX *logFontEx, NEWTEXTMETRICEX *metric, int fontType, LPARAM lParam)
{
	if (lParam)
	{
		return ((CFontEnumerator *)lParam)->handleEnumerationEvent(logFontEx, metric, fontType);
	}
	return FALSE;
}

//  ===========================================================================
long CFontEnumerator::handleEnumerationEvent(ENUMLOGFONTEX *logFontEx, NEWTEXTMETRICEX *metric, int fontType)
{
	if ((fontType & TRUETYPE_FONTTYPE) == 0)
	{
		return TRUE;
	}

	m_fontArray->addElement(new CFontReference((const char *)logFontEx->elfFullName, (const char *)logFontEx->elfLogFont.lfFaceName));
	return TRUE;
}
#endif

//  ===========================================================================
void CFontEnumerator::findFonts()
{
#ifdef WIN32
	LOGFONT logFont;
	memset(&logFont, 0, sizeof(logFont));
	logFont.lfCharSet        = DEFAULT_CHARSET;
	logFont.lfFaceName[0]    = '\0';
	logFont.lfPitchAndFamily = 0;

	HDC drawContext = GetDC(NULL);
	EnumFontFamiliesEx(drawContext, &logFont, (FONTENUMPROC)enumerateProcess, (LPARAM)this, 0);
	ReleaseDC(NULL, drawContext);
#else
	// Okay mac its all inside one function...
    ATSFontIterator iterator;

    // Construct the iterator
    if (ATSFontIteratorCreate(kATSFontContextGlobal, 0, 0, kATSOptionFlagsRestrictedScope, &iterator) == noErr)
    {
        // Construct a references to the font to be used inside the loop
        ATSFontRef theFont;

        // Loop through each font
        while(ATSFontIteratorNext(iterator, &theFont) == noErr)
        {

            // The font name is next
            CFStringRef fontName;

            // Try to get the name of the font
            if (ATSFontGetName(theFont, kATSOptionFlagsDefault, &fontName) == noErr)
            {
                char buffer[1024];
                memset(buffer, 0, 1024 * sizeof(char));
                if (CFStringGetCString(fontName, buffer, 1024, kCFStringEncodingMacRoman))
                {
					m_fontArray->addElement(new CFontReference(CFStringGetCStringPtr(fontName, kCFStringEncodingMacRoman), CString("")));
                }

                // Release the string, we are finished with it
                CFRelease(fontName);
            }
        }

        // Release the iterator
        ATSFontIteratorRelease(&iterator);
    }
#endif
}